<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Caminho do autoload (via Composer ou manual)
require 'vendor/autoload.php'; // ou 'PHPMailer/src/PHPMailer.php', etc.

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // --- CONFIGURAÇÕES DO E-MAIL ---
    $destinatario = "clemente@cioa.ao"; // E-mail de destino
    $assunto = "Nova Solicitação de Cotação - Patrocinador";

    // --- DADOS DO FORMULÁRIO ---
    $empresa   = htmlspecialchars($_POST['empresa'] ?? '');
    $nif       = htmlspecialchars($_POST['nif'] ?? '');
    $morada    = htmlspecialchars($_POST['morada'] ?? '');
    $email     = htmlspecialchars($_POST['email'] ?? '');
    $country   = htmlspecialchars($_POST['country'] ?? '');
    $phone     = htmlspecialchars($_POST['phone'] ?? '');
    $service   = htmlspecialchars($_POST['service'] ?? '');

    // --- VALIDAÇÃO ---
    if (empty($empresa) || empty($nif) || empty($morada) || empty($email) || empty($phone) || empty($service)) {
        echo "<script>alert('Por favor, preencha todos os campos obrigatórios.'); window.history.back();</script>";
        exit;
    }

    // --- MENSAGEM FORMATADA ---
    $mensagem = "
    <html>
    <head><title>Nova Solicitação de Cotação</title></head>
    <body style='font-family: Arial, sans-serif;'>
        <h2>📄 Solicitação de Cotação - Patrocinador</h2>
        <p><strong>Empresa:</strong> {$empresa}</p>
        <p><strong>NIF:</strong> {$nif}</p>
        <p><strong>Morada:</strong> {$morada}</p>
        <p><strong>E-mail:</strong> {$email}</p>
        <p><strong>País:</strong> {$country}</p>
        <p><strong>Telefone:</strong> {$phone}</p>
        <p><strong>Pacote Selecionado:</strong> {$service}</p>
        <hr>
        <p>📅 Enviado em: " . date('d/m/Y H:i:s') . "</p>
    </body>
    </html>
    ";

    // --- CONFIGURAÇÃO DO PHPMailer ---
    $mail = new PHPMailer(true);

    try {
        // Configurações do servidor SMTP
        $mail->isSMTP();
        $mail->Host       = 'mail.ciao.ao';      // 🔹 Endereço SMTP do seu servidor
        $mail->SMTPAuth   = true;
        $mail->Username   = 'clemente@cioa.ao'; // 🔹 Seu e-mail de envio
        $mail->Password   = 'Admin@cioa';      // 🔹 Senha do e-mail (ou senha de app)
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // ou 'ssl' se o servidor exigir
        $mail->Port       = 465;                   // Porta SMTP: 587 (TLS) ou 465 (SSL)

        // Remetente e destinatário
        $mail->setFrom('clemente@cioa.ao', 'Formulário de Patrocínio');
        $mail->addAddress($destinatario, 'Equipe CIOA');
        $mail->addReplyTo($email, $empresa); // responder para o e-mail do remetente

        // Conteúdo
        $mail->isHTML(true);
        $mail->Subject = $assunto;
        $mail->Body    = $mensagem;

        // Enviar o e-mail
        $mail->send();

        echo "<script>alert('✅ Solicitação enviada com sucesso! Entraremos em contato em breve.'); window.location.href='index.html';</script>";

    } catch (Exception $e) {
        echo "<script>alert('❌ Falha ao enviar: {$mail->ErrorInfo}'); window.history.back();</script>";
    }
} else {
    echo "<script>alert('Método inválido de envio.'); window.history.back();</script>";
}
?>
